#ifndef KRAMPUS_INC_MAP_HPP
#define KRAMPUS_INC_MAP_HPP

#include <ctime>
#include <string>
#include <vector>
#include <iostream>

#include <allegro5/allegro.h>

#include <inc/random.hpp>

using std::cout;
using std::stoi;
using std::time;
using std::string;
using std::vector;

class Map {

  public:

    Map(void);

    bool loadBitmap(void);

    void render(const float, const float);

    void loadTiles(void);

    void destroyBitmap(void);

    void setRandomNumberGenerator(Random *);

    vector < vector < string > > &getTiles(void);

  private:

    unsigned int w;
    unsigned int h;

    unsigned int tile_w;
    unsigned int tile_h;

    vector < vector < string > > tiles;

    ALLEGRO_BITMAP *bitmap;

    Random *RandomNumberGenerator;

    void generateTiles(const unsigned int probability, const string tile_data);
};

#endif
